/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;


import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;


import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.MailAddress;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/**
 * 
 * @author 564685
 */
public class SendErrors implements Runnable {

	private static final Log LOGGER = LogFactory.getFactory().getInstance(
			SendErrors.class);
	private static Lock wrlock = new ReentrantLock();
	private static ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(
			1);

	private static final Integer MAX_TIME = 10080;// A week of min
	private static final Integer MIN_TIME = 1; // 1 min

	public static void lock() {
		wrlock.lock();
	}

	public static void unlock() {
		wrlock.unlock();
	}

	private SendErrors() {
	}

	public static void startThread() throws MailetPropertiesException {
		Map<String, String> properties = MailetProperties
				.updatedPropertiesList();
		if (properties != null) {
			MailetProperties.setPropertiesList(properties);
			Integer wait_time = MIN_TIME;
			try {
				wait_time = Integer.parseInt(properties
						.get("mailet.error.refresh"));
			} catch (NumberFormatException e) {
				wait_time = MIN_TIME;
			}
			if(wait_time < MIN_TIME){
				wait_time = MIN_TIME;
			}else if(wait_time > MAX_TIME){
				wait_time = MAX_TIME;
			}
			SendErrors mm = new SendErrors();
			stpe.scheduleAtFixedRate(mm, wait_time, wait_time, TimeUnit.MINUTES);
		} else {
			throw new MailetPropertiesException("Failed to load properties");

		}

	}

	public void run() {

		try {
			Map<String, String> properties = MailetProperties
					.updatedPropertiesList();
			if (properties != null) {// if you can get properties update
										// properties
				MailetProperties.setPropertiesList(properties);
			}
			send();
		} catch (Exception e) {
			LOGGER.error("Unexpected Exception in SendErrors: Exception "
					+ e.getClass() + " " + e.getMessage());// catch all
		}

	}

	/**
	 * Main method that looks for files and calls send message to send the
	 * files.
	 * 
	 */
	private void send() {
		Map<String, String> properties = MailetProperties
				.updatedPropertiesList();
		String folder_path = properties.get("mailet.error.folder");
		String aes = properties.get("mailet.error.aes");
		int sent = 0;
		lock();
		if (folder_path == null) {
			LOGGER.error("Folder path is null");
			unlock();
			return;
		}
               
		File folder;
            try {
                URL url = new URL("file:"+folder_path);
                folder = new File(url.toURI()); 
            } catch (URISyntaxException ex) {
                unlock();
                LOGGER.error("Path not found");
                return;
            } catch (MalformedURLException ex) {
                 unlock();
                LOGGER.error("Malformed Path");
                return;
            }

		File[] listOfFiles = null;
		try {
			listOfFiles = folder.listFiles();
		} catch (SecurityException se) {
			unlock();
			LOGGER.error("You do not have read permissions on the folder");
		}
		unlock();
		if (listOfFiles == null || listOfFiles.length == 0) {
			return;
		}
		
		if (aes != null) {

			for (int i = 0; i < listOfFiles.length; i++) {
				if (sendMessge(aes, listOfFiles[i])) {
					try {
						if (!listOfFiles[i].delete()) {
							LOGGER.error("Failed to delete message from local.");
						} else {
							sent++;
						}
					} catch (SecurityException se) {
						LOGGER.error("You do not have permission to delete the file");
					}
				}
			}

			LOGGER.info(sent + " messages were sent and deleted localy.");

		}
	}

	private boolean sendMessge(String key, File file) {
		ObjectInputStream inobj = null;
		ArrayList arl = null;
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(file);
			inobj = new ObjectInputStream(fis);
			Object obj = null;
			try {
				obj = inobj.readObject();
			} catch (ClassNotFoundException ex) {
				LOGGER.error("Can't get object from file " + file);
				return false;
			}

			arl = (ArrayList) obj;
			inobj.close();
		} catch (IOException ex) {
			LOGGER.error("Failed to load file " + file);
			return false;
		} finally {

			try {
				if (fis != null) {
					fis.close();
				}
			} catch (IOException e) {
				LOGGER.debug("Could not close file " + file);
			}

		}

		if (arl != null) {
			byte[] salt =(byte[]) arl.get(1);
			byte[] aes = (sha256(key)+salt).getBytes();
                        aes = Arrays.copyOf(aes, 32);
                       
			if (aes != null) {

				IvParameterSpec IV = new IvParameterSpec((byte[]) arl.get(0));
				ArrayList<MailAddress> recipients = ((ArrayList<MailAddress>) arl.get(2));

				AddressCheck lefttosend = ((AddressCheck) arl.get(19));

				try {
                                        String sender = decryptString((byte[]) arl.get(3), aes, IV);

					String attachments = decryptString((byte[]) arl.get(4),
							aes, IV);
					String subject = decryptString((byte[]) arl.get(5), aes, IV);
					String body = decryptString((byte[]) arl.get(6), aes, IV);
					String html = decryptString((byte[]) arl.get(7), aes, IV);
					String timestring = decryptString((byte[]) arl.get(8), aes,
							IV);
					String sizestring = decryptString((byte[]) arl.get(9), aes,
							IV);
					String headers = decryptString((byte[]) arl.get(10), aes,
							IV);
					byte[] message = decrypt((byte[]) arl.get(11), aes, IV);
					String message_id = decryptString((byte[]) arl.get(12),
							aes, IV);
					String to = decryptString((byte[]) arl.get(13), aes, IV);
					String cc = decryptString((byte[]) arl.get(14), aes, IV);
					String bcc = decryptString((byte[]) arl.get(15), aes, IV);
					String prioritystring = decryptString((byte[]) arl.get(16), aes, IV);
					String mailtype = decryptString((byte[]) arl.get(17), aes, IV);


                                        boolean request_dispatched = decryptString((byte[]) arl.get(18), aes, IV).equals("true");
					long time = 0;
					try {
						time = Long.parseLong(timestring);
					} catch (NumberFormatException e) {
						LOGGER.debug("could not parse time");
						time = new Date().getTime() / 1000L;
					}
					long size = 0;
					try {
						size = Long.parseLong(sizestring);
					} catch (NumberFormatException e) {
						size = message.length * 8;
						LOGGER.debug("could not parse size");
					}
					int priority = 3;
					try {
						priority = Integer.parseInt(prioritystring);
					} catch (NumberFormatException e) {
						LOGGER.debug("could not parse priority");
					}
					SendMail.sendMessage(recipients, sender, attachments,
							subject, body, html, time, size, headers, message,
							message_id, to, cc, bcc,priority,mailtype, lefttosend, request_dispatched);

					return true;
				} catch (DecryptionException e1) {
					LOGGER.debug("Failed to decrypt");
					return false;
				}

			}
		} else {
			LOGGER.error("Failed to create send message.  No array");
		}
		return false;
	}

	private byte[] decrypt(byte[] cipherText, byte[] encryptionKey,
			IvParameterSpec IV) throws DecryptionException {
		if (cipherText == null) {
			return null;
		}
		Cipher cipher;
		try {
			cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
		} catch (NoSuchAlgorithmException e) {
			throw new DecryptionException("No Such Algorithm for decryption");
		} catch (NoSuchProviderException e) {
			throw new DecryptionException("No Such Provider for decryption");
		} catch (NoSuchPaddingException e) {
			throw new DecryptionException("No Such Padding for decryption");
		}
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
		try {
			cipher.init(Cipher.DECRYPT_MODE, key, IV);
		} catch (InvalidKeyException e) {
			throw new DecryptionException("Invalid Key For decryption");
		} catch (InvalidAlgorithmParameterException e) {
			throw new DecryptionException("Invalid Algorithm for decryption");
		}
		byte[] ret = null;
		try {
			ret = (cipher.doFinal(cipherText));
		} catch (IllegalBlockSizeException e) {
			throw new DecryptionException("Illegal block size for decryption");
		} catch (BadPaddingException e) {
			throw new DecryptionException("Bad Padding for decryption");
		}
		return ret;
	}

	private String decryptString(byte[] cipherText, byte[] encryptionKey,
			IvParameterSpec IV) throws DecryptionException {
		byte[] decrypted = decrypt(cipherText, encryptionKey, IV);
		if (decrypted != null) {
			String ret = null;
			try {
				ret = new String(decrypted, "UTF-8");
			} catch (UnsupportedEncodingException e) {
				ret = new String(decrypted);
			}

			return ret;
		}
		return null;
	}

	public static class MailetPropertiesException extends Exception {

		public MailetPropertiesException() {
			super();
		}

		public MailetPropertiesException(String message) {
			super(message);
		}
	}

	public static class DecryptionException extends Exception {

		public DecryptionException() {
			super();
		}

		public DecryptionException(String message) {
			super(message);
		}
	}

	public static class TimeException extends Exception {
		public TimeException(String message) {
			super(message);
		}
	}
        private static String sha256(String base) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();

            for (int i = 0; i < hash.length; i++) {
                String hex = Integer.toHexString(0xff & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }

            return hexString.toString();
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}


